CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM pg_views 
                    WHERE viewname = 'v_pdv_vd_menu_fiscal_estoque_prod') THEN 
		DROP VIEW IF EXISTS v_pdv_vd_menu_fiscal_estoque_prod;
        RAISE NOTICE 'v_pdv_vd_menu_fiscal_estoque_prod removida.';
    END IF; 
	
	CREATE OR REPLACE VIEW public.v_pdv_vd_menu_fiscal_estoque_prod
	AS SELECT est_prod_cpl.cd_emp,
		est_prod_cpl.cd_filial,
		prc_filial.cgc,
		prc_filial.insc_est,
		prc_filial.insc_muni,
		prc_filial.rz_filial,
		est_prod_cpl.cd_prod,
		est_prod.ds_prod,
		est_prod_cpl.dt_estoque,
		COALESCE(prod_un_med.ds_un, 'UN'::character varying, prod_un_med.ds_un) AS unidade,
		COALESCE(( SELECT b.cd_barra
			   FROM est_prod_cd_barra b
			  WHERE est_prod.cd_emp = b.cd_emp AND est_prod.cd_prod = b.cd_prod
			 LIMIT 1), est_prod.cd_prod::character varying) AS cd_barra,
		est_prod_cpl.qt_estq_ini_dia AS qt_est,
		est_prod_cpl.cd_trib_vd,
		est_prod_cpl.perc_icms_n_cont_esta,
		est_prod_cpl.perc_red_vd,
			CASE
				WHEN (COALESCE(est_prod.reg_alterado::boolean, false) OR COALESCE(est_prod_cpl.reg_alterado::boolean, false) OR COALESCE(est_prod_preco.reg_alterado::boolean, false)) = true THEN 1
				ELSE 0
			END AS reg_alterado,
		prc_filial.reg_alterado AS reg_alterado_filial,
		est_prod.ncm_prod,
		est_prod.NR_CEST
	   FROM est_prod
		 JOIN est_prod_cpl ON est_prod.cd_emp = est_prod_cpl.cd_emp AND est_prod.cd_prod = est_prod_cpl.cd_prod
		 JOIN prc_filial ON est_prod_cpl.cd_emp = prc_filial.cd_emp AND est_prod_cpl.cd_filial = prc_filial.cd_filial
		 JOIN est_trib ON est_prod_cpl.cd_trib_vd = est_trib.cd_trib
		 LEFT JOIN est_prod_preco ON est_prod_cpl.cd_emp = est_prod_preco.cd_emp AND est_prod_cpl.cd_filial = est_prod_preco.cd_filial AND est_prod_cpl.cd_prod = est_prod_preco.cd_prod
		 LEFT JOIN est_prod_un_med prod_un_med ON est_prod.cd_un_vd = prod_un_med.cd_ctr_un;
	
	RAISE NOTICE 'View v_pdv_vd_menu_fiscal_estoque_prod recriada.'; 
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();